
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="airborne_infantry_companies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="engineer_platoons", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.75 * x1**2 + 5.18 * x1 * x2 + 3.76 * x1, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(1.02 * x1 + 4.73 * x2 >= 19, name="total_deployment_weight")
m.addConstr(0.3 * x1 + 1.69 * x2 >= 44, name="total_defensive_capability_rating")
m.addConstr(1.34 * x1 + 0.4 * x2 >= 65, name="total_fun_factor")
m.addConstr(2.7 * x1 + 0.65 * x2 >= 41, name="total_mobility_rating")
m.addConstr(-8 * x1 + 9 * x2 >= 0, name="linear_constraint")
m.addConstr(1.02 * x1 + 4.73 * x2 <= 78, name="combined_deployment_weight_upper_bound")
m.addConstr((0.3 * x1)**2 + (1.69 * x2)**2 <= 54, name="defensive_capability_rating_squared_upper_bound")
m.addConstr((1.34 * x1)**2 + (0.4 * x2)**2 <= 102, name="fun_factor_squared_upper_bound")
m.addConstr((2.7 * x1)**2 + (0.65 * x2)**2 <= 198, name="mobility_rating_squared_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Airborne Infantry Companies: ", x1.varValue)
    print("Engineer Platoons: ", x2.varValue)
else:
    print("The model is infeasible")
