
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")


# Set objective function
m.setObjective(6*green_beans + 8*corn_cobs + 5*oranges + 9*kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20*green_beans + 13*corn_cobs + 2*oranges + 4*kiwis <= 280, "r0")
m.addConstr(14*green_beans + 3*corn_cobs + 1*oranges + 11*kiwis <= 284, "r1")
m.addConstr(10*green_beans + 22*corn_cobs + 14*oranges + 10*kiwis <= 270, "r2")
m.addConstr(22*green_beans + 9*corn_cobs + 18*oranges + 3*kiwis <= 315, "r3")
m.addConstr(13*corn_cobs + 4*kiwis >= 63, "c5")
m.addConstr(2*oranges + 4*kiwis >= 39, "c6")
m.addConstr(20*green_beans + 13*corn_cobs + 4*kiwis >= 62, "c7")
m.addConstr(20*green_beans + 13*corn_cobs + 2*oranges >= 68, "c8")
m.addConstr(20*green_beans + 13*corn_cobs + 4*kiwis >= 68, "c9")
m.addConstr(20*green_beans + 13*corn_cobs + 2*oranges >= 62, "c10")
m.addConstr(20*green_beans + 13*corn_cobs + 2*oranges + 4*kiwis >= 68, "c11")
m.addConstr(14*green_beans + 11*kiwis >= 44, "c12")
m.addConstr(14*green_beans + 3*corn_cobs >= 62, "c13")
m.addConstr(3*corn_cobs + 1*oranges >= 36, "c14")
m.addConstr(14*green_beans + 3*corn_cobs + 1*oranges + 11*kiwis >= 36, "c15")
m.addConstr(22*corn_cobs + 10*kiwis >= 33, "c16")
m.addConstr(22*corn_cobs + 14*oranges >= 63, "c17")
m.addConstr(10*green_beans + 22*corn_cobs + 14*oranges + 10*kiwis >= 63, "c18")
m.addConstr(22*green_beans + 9*corn_cobs >= 29, "c19")
m.addConstr(22*green_beans + 3*kiwis >= 66, "c20")
m.addConstr(9*corn_cobs + 3*kiwis >= 64, "c21")
m.addConstr(18*oranges + 3*kiwis >= 51, "c22")
m.addConstr(9*corn_cobs + 18*oranges >= 43, "c23")
m.addConstr(22*green_beans + 18*oranges + 3*kiwis >= 52, "c24")
m.addConstr(9*corn_cobs + 18*oranges + 3*kiwis >= 52, "c25")
m.addConstr(22*green_beans + 18*oranges + 3*kiwis >= 64, "c26")
m.addConstr(9*corn_cobs + 18*oranges + 3*kiwis >= 64, "c27")
m.addConstr(22*green_beans + 9*corn_cobs + 18*oranges + 3*kiwis >= 64, "c28")
m.addConstr(-6*green_beans + 9*kiwis >= 0, "c29")
m.addConstr(9*green_beans - 4*corn_cobs >= 0, "c30")
m.addConstr(5*corn_cobs - 2*oranges >= 0, "c31")
m.addConstr(13*corn_cobs + 2*oranges + 4*kiwis <= 270, "c32")
m.addConstr(20*green_beans + 13*corn_cobs + 2*oranges <= 256, "c33")
m.addConstr(14*green_beans + 11*kiwis <= 114, "c34")
m.addConstr(3*corn_cobs + 11*kiwis <= 201, "c35")
m.addConstr(14*green_beans + 3*corn_cobs + 11*kiwis <= 192, "c36")
m.addConstr(3*corn_cobs + 1*oranges + 11*kiwis <= 107, "c37")
m.addConstr(10*green_beans + 22*corn_cobs + 10*kiwis <= 98, "c38")
m.addConstr(22*green_beans + 18*oranges <= 102, "c39")
m.addConstr(9*corn_cobs + 3*kiwis <= 252, "c40")
m.addConstr(9*corn_cobs + 18*oranges <= 278, "c41")
m.addConstr(22*green_beans + 3*kiwis <= 263, "c42")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

