
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="green_beans", lb=0)  # Green beans
x1 = m.addVar(name="corn_cobs", lb=0)  # Corn cobs
x2 = m.addVar(name="oranges", lb=0)  # Oranges
x3 = m.addVar(name="kiwis", lb=0)  # Kiwis

# Objective function
m.setObjective(6 * x0 + 8 * x1 + 5 * x2 + 9 * x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(20 * x0 + 13 * x1 + 2 * x2 + 4 * x3 <= 280)  # r0
m.addConstr(14 * x0 + 3 * x1 + x2 + 11 * x3 <= 284)  # r1
m.addConstr(10 * x0 + 22 * x1 + 14 * x2 + 10 * x3 <= 270)  # r2
m.addConstr(22 * x0 + 9 * x1 + 18 * x2 + 3 * x3 <= 315)  # r3
m.addConstr(13 * x1 + 4 * x3 >= 63)
m.addConstr(2 * x2 + 4 * x3 >= 39)
m.addConstr(20 * x0 + 13 * x1 + 4 * x3 >= 62)
m.addConstr(20 * x0 + 13 * x1 + 2 * x2 >= 62)
m.addConstr(20 * x0 + 13 * x1 + 4 * x3 >= 68)
m.addConstr(20 * x0 + 13 * x1 + 2 * x2 >= 68)
m.addConstr(14 * x0 + 11 * x3 >= 44)
m.addConstr(14 * x0 + 3 * x1 >= 62)
m.addConstr(3 * x1 + x2 >= 36)
m.addConstr(14 * x0 + 3 * x1 + x2 + 11 * x3 >= 36)
m.addConstr(22 * x1 + 10 * x3 >= 33)
m.addConstr(22 * x1 + 14 * x2 >= 63)
m.addConstr(10 * x0 + 22 * x1 + 14 * x2 + 10 * x3 >= 63)
m.addConstr(22 * x0 + 9 * x1 >= 29)
m.addConstr(22 * x0 + 3 * x3 >= 66)
m.addConstr(9 * x1 + 3 * x3 >= 64)
m.addConstr(18 * x2 + 3 * x3 >= 51)
m.addConstr(9 * x1 + 18 * x2 >= 43)
m.addConstr(22 * x0 + 18 * x2 + 3 * x3 >= 52)
m.addConstr(9 * x1 + 18 * x2 + 3 * x3 >= 52)
m.addConstr(22 * x0 + 18 * x2 + 3 * x3 >= 64)
m.addConstr(9 * x1 + 18 * x2 + 3 * x3 >= 64)
m.addConstr(22 * x0 + 9 * x1 + 18 * x2 + 3 * x3 >= 64)
m.addConstr(-6 * x0 + 9 * x3 >= 0)
m.addConstr(9 * x0 - 4 * x1 >= 0)
m.addConstr(5 * x1 - 2 * x2 >= 0)
m.addConstr(13 * x1 + 2 * x2 + 4 * x3 <= 270)
m.addConstr(20 * x0 + 13 * x1 + 2 * x2 <= 256)
m.addConstr(14 * x0 + 11 * x3 <= 114)
m.addConstr(3 * x1 + 11 * x3 <= 201)
m.addConstr(14 * x0 + 3 * x1 + 11 * x3 <= 192)
m.addConstr(3 * x1 + x2 + 11 * x3 <= 107)
m.addConstr(10 * x0 + 22 * x1 + 10 * x3 <= 98)
m.addConstr(22 * x0 + 14 * x2 <= 102)
m.addConstr(9 * x1 + 3 * x3 <= 252)
m.addConstr(9 * x1 + 18 * x2 <= 278)
m.addConstr(22 * x0 + 3 * x3 <= 263)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Green beans: ", x0.varValue)
    print("Corn cobs: ", x1.varValue)
    print("Oranges: ", x2.varValue)
    print("Kiwis: ", x3.varValue)
else:
    print("The model is infeasible")
