
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Paul")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by George")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Jean")


    # Set objective function
    model.setObjective(8.52 * x0 + 1.56 * x1 + 5.06 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 2 * x2 >= 23)
    model.addConstr(10 * x0 + 14 * x1 >= 17)
    model.addConstr(10 * x0 + 14 * x1 + 2 * x2 >= 17)
    model.addConstr(9 * x0 + 14 * x2 >= 40)
    model.addConstr(9 * x0 + 8 * x1 >= 16)
    model.addConstr(8 * x1 + 14 * x2 >= 45)
    model.addConstr(9 * x0 + 8 * x1 + 14 * x2 >= 45)
    model.addConstr(14 * x0 + 11 * x2 >= 29)
    model.addConstr(14 * x0 + 11 * x1 >= 19)
    model.addConstr(14 * x0 + 11 * x1 + 11 * x2 >= 19)
    model.addConstr(14 * x1 + 12 * x2 >= 33)
    model.addConstr(13 * x0 + 14 * x1 >= 22)
    model.addConstr(13 * x0 + 14 * x1 + 12 * x2 >= 22)
    model.addConstr(7 * x1 - 3 * x2 >= 0)
    model.addConstr(10 * x0 + 14 * x1 + 2 * x2 <= 65)
    model.addConstr(14 * x0 + 11 * x1 <= 63)
    model.addConstr(14 * x1 + 12 * x2 <= 69)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
