
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean

    # Objective function
    model.setObjective(8.52 * x0 + 1.56 * x1 + 5.06 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * x0 <= 103)
    model.addConstr(9 * x0 <= 141)
    model.addConstr(14 * x0 <= 109)
    model.addConstr(13 * x0 <= 106)

    model.addConstr(14 * x1 <= 103)
    model.addConstr(8 * x1 <= 141)
    model.addConstr(11 * x1 <= 109)
    model.addConstr(14 * x1 <= 106)

    model.addConstr(2 * x2 <= 103)
    model.addConstr(14 * x2 <= 141)
    model.addConstr(11 * x2 <= 109)
    model.addConstr(12 * x2 <= 106)

    model.addConstr(14 * x1 + 2 * x2 >= 23)
    model.addConstr(10 * x0 + 14 * x1 >= 17)
    model.addConstr(10 * x0 + 14 * x1 + 2 * x2 >= 17)
    model.addConstr(9 * x0 + 14 * x2 >= 40)
    model.addConstr(9 * x0 + 8 * x1 >= 16)
    model.addConstr(8 * x1 + 14 * x2 >= 45)
    model.addConstr(9 * x0 + 8 * x1 + 14 * x2 >= 45)
    model.addConstr(14 * x0 + 11 * x2 >= 29)
    model.addConstr(14 * x0 + 11 * x1 >= 19)
    model.addConstr(14 * x0 + 11 * x1 + 11 * x2 >= 19)
    model.addConstr(14 * x1 + 12 * x2 >= 33)
    model.addConstr(13 * x0 + 14 * x1 >= 22)
    model.addConstr(13 * x0 + 14 * x1 + 12 * x2 >= 22)
    model.addConstr(7 * x1 - 3 * x2 >= 0)

    model.addConstr(10 * x0 + 14 * x1 + 2 * x2 <= 65)
    model.addConstr(14 * x0 + 11 * x1 <= 63)
    model.addConstr(14 * x1 + 12 * x2 <= 69)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by George: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
