
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")


    # Set objective function
    model.setObjective(2*x0**2 + 7*x0*x1 + 6*x0 + 2*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 10*x1 >= 87, "c0")
    model.addConstr(4*x0 + 5*x1 >= 34, "c1")
    model.addConstr(7*x0 - 3*x1 >= 0, "c2")
    model.addConstr(5*x0 + 10*x1 <= 116, "c3")
    model.addConstr(4*x0 + 5*x1 <= 141, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"hours worked by Dale: {x0.x}")
        print(f"hours worked by George: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
