
import gurobi as grb

# Create a new model
m = grb.Model()

# Define variables
x1 = m.addVar(name="hours_worked_by_Dale", vtype=grb.GRB.INTEGER, lb=0)
x2 = m.addVar(name="hours_worked_by_George", vtype=grb.GRB.CONTINUOUS, lb=0)

# Objective function
m.setObjective(2*x1**2 + 7*x1*x2 + 6*x1 + 2*x2, grb.GRB.MINIMIZE)

# Constraints
m.addConstr(x1 == 1, name="Dale_fixed")
m.addConstr(x2 == 1, name="George_fixed")

m.addConstr(5*x1 + 10*x2 >= 87, name="combined_likelihood_to_quit_min")
m.addConstr(4*x1 + 5*x2 >= 34, name="combined_productivity_rating_min")

m.addConstr(7*x1 - 3*x2 >= 0, name="linear_constraint")

m.addConstr(5*x1 + 10*x2 <= 116, name="combined_likelihood_to_quit_max")
m.addConstr(4*x1 + 5*x2 <= 141, name="combined_productivity_rating_max")

# Optimize
m.optimize()

# Print solution
if m.status == grb.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by George: ", x2.varValue)
else:
    print("No solution found")
