
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
slices_of_pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")


# Set objective function
m.setObjective(9*bagged_salads + 1*oranges + 3*chicken_breasts + 6*protein_bars + 1*slices_of_pizza + 2*steaks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10*oranges + 7*protein_bars >= 85)
m.addConstr(7*protein_bars + 5*steaks >= 66)
m.addConstr(10*oranges + 9*slices_of_pizza >= 90)
m.addConstr(7*protein_bars + 9*slices_of_pizza >= 64)
m.addConstr(10*oranges + 5*steaks >= 76)
m.addConstr(18*chicken_breasts + 9*slices_of_pizza >= 60)
m.addConstr(18*bagged_salads + 9*slices_of_pizza >= 66)
m.addConstr(9*slices_of_pizza + 5*steaks >= 40)
m.addConstr(18*bagged_salads + 18*chicken_breasts >= 42)
m.addConstr(18*bagged_salads + 10*oranges + 18*chicken_breasts + 7*protein_bars + 9*slices_of_pizza + 5*steaks >= 42)
m.addConstr(17*bagged_salads + 8*steaks >= 61)
m.addConstr(11*chicken_breasts + 10*protein_bars >= 48)
m.addConstr(18*oranges + 11*chicken_breasts + 8*steaks >= 50)
m.addConstr(18*oranges + 1*slices_of_pizza + 8*steaks >= 50)
m.addConstr(18*oranges + 11*chicken_breasts + 10*protein_bars >= 50)
m.addConstr(18*oranges + 11*chicken_breasts + 8*steaks >= 59)
m.addConstr(18*oranges + 1*slices_of_pizza + 8*steaks >= 59)
m.addConstr(18*oranges + 11*chicken_breasts + 10*protein_bars >= 59)
m.addConstr(18*oranges + 11*chicken_breasts + 8*steaks >= 40)
m.addConstr(18*oranges + 1*slices_of_pizza + 8*steaks >= 40)
m.addConstr(18*oranges + 11*chicken_breasts + 10*protein_bars >= 40)
m.addConstr(17*bagged_salads + 18*oranges + 11*chicken_breasts + 10*protein_bars + 1*slices_of_pizza + 8*steaks >= 40)
m.addConstr(5*oranges + 6*protein_bars >= 21)
m.addConstr(6*protein_bars + 5*slices_of_pizza >= 26)
m.addConstr(5*oranges + 15*steaks >= 16)
m.addConstr(5*bagged_salads + 5*slices_of_pizza >= 27)
m.addConstr(12*chicken_breasts + 5*slices_of_pizza >= 18)
m.addConstr(5*slices_of_pizza + 15*steaks >= 26)
m.addConstr(5*oranges + 5*slices_of_pizza >= 32)
m.addConstr(5*bagged_salads + 6*protein_bars >= 19)
m.addConstr(5*oranges + 12*chicken_breasts >= 30)
m.addConstr(5*bagged_salads + 5*oranges + 12*chicken_breasts + 6*protein_bars + 5*slices_of_pizza + 15*steaks >= 30)


m.addConstr(-3*bagged_salads + 5*slices_of_pizza >= 0)
m.addConstr(18*bagged_salads + 18*chicken_breasts <= 365)
m.addConstr(18*chicken_breasts + 5*steaks <= 320)
m.addConstr(7*protein_bars + 5*steaks <= 348)
m.addConstr(10*oranges + 7*protein_bars <= 379)
m.addConstr(7*protein_bars + 9*slices_of_pizza <= 476)
m.addConstr(18*bagged_salads + 9*slices_of_pizza <= 527)
m.addConstr(18*chicken_breasts + 7*protein_bars <= 530)
m.addConstr(18*bagged_salads + 7*protein_bars <= 231)
m.addConstr(18*bagged_salads + 5*steaks <= 383)
m.addConstr(18*chicken_breasts + 9*slices_of_pizza <= 397)
m.addConstr(10*oranges + 9*slices_of_pizza <= 145)
m.addConstr(18*bagged_salads + 18*chicken_breasts + 7*protein_bars <= 111)
m.addConstr(18*bagged_salads + 10*oranges + 18*chicken_breasts <= 506)
m.addConstr(18*bagged_salads + 10*oranges + 9*slices_of_pizza <= 311)
m.addConstr(10*oranges + 18*chicken_breasts + 7*protein_bars <= 283)
m.addConstr(18*oranges + 10*protein_bars + 1*slices_of_pizza <= 353)
m.addConstr(17*bagged_salads + 18*oranges + 11*chicken_breasts <= 356)
m.addConstr(11*chicken_breasts + 1*slices_of_pizza + 8*steaks <= 162)
m.addConstr(12*chicken_breasts + 5*slices_of_pizza <= 66)
m.addConstr(5*slices_of_pizza + 15*steaks <= 128)
m.addConstr(5*oranges + 15*steaks <= 81)
m.addConstr(5*bagged_salads + 12*chicken_breasts + 5*slices_of_pizza <= 54)
m.addConstr(5*bagged_salads + 12*chicken_breasts + 15*steaks <= 194)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

