
from gurobipy import *

# Create a new model
m = Model("Likelihood_to_Quit_Index")

# Define variables
x1, x2, x3, x4, x5, x6, x7, x8, x9 = m.addVars(9, vtype=GRB.INTEGER)

# Objective function (assuming minimization of total hours as a placeholder)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9, GRB.MINIMIZE)

# Add constraints
# Note: This is a simplified representation. You need to add all your specific constraints here.
# For example:
m.addConstr(x1 + x2 <= 330)  # Example constraint
m.addConstr(x3 + x4 <= 82)
m.addConstr(x5 + x6 <= 120)
# ... Add the rest of your constraints similarly

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found")
