
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")
paul = m.addVar(vtype=GRB.CONTINUOUS, name="paul")
dale = m.addVar(vtype=GRB.CONTINUOUS, name="dale")

# Set objective function
m.setObjective(1.43*hank**2 + 2.51*hank*bobby + 7.13*hank*dale + 6.72*paul**2 + 7.26*paul*dale + 5.39*dale**2 + 1.47*paul + 1.27*dale, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*hank + 1*dale >= 19)
m.addConstr(3*hank**2 + 7*bobby**2 >= 17)
m.addConstr(3*hank + 7*bobby + 1*dale >= 15)
m.addConstr(8*hank + 2*paul + 8*dale >= 16)
m.addConstr(2*bobby + 2*paul + 8*dale >= 16)
m.addConstr(8*hank + 2*bobby + 8*dale >= 16)
m.addConstr(8*hank + 2*paul + 8*dale >= 26)
m.addConstr(2*bobby + 2*paul + 8*dale >= 26)
m.addConstr(8*hank + 2*bobby + 8*dale >= 26)
m.addConstr(8*hank + 2*paul + 8*dale >= 22)
m.addConstr(8*bobby**2 + 2*paul**2 + 8*dale**2 >= 22)
m.addConstr(8*hank + 2*bobby + 8*dale >= 22)
m.addConstr(4*paul + 3*dale >= 18)
m.addConstr(4*bobby**2 + 3*dale**2 >= 12)
m.addConstr(8*hank + 4*bobby + 3*dale >= 11)
m.addConstr(3*hank + 5*paul <= 88)
m.addConstr(3*hank**2 + 7*bobby**2 <= 58)
m.addConstr(7*bobby**2 + 1*dale**2 <= 72)
m.addConstr(3*hank + 1*dale <= 74)
m.addConstr(3*hank + 7*bobby + 5*paul + 1*dale <= 74)
m.addConstr(8*hank + 8*dale <= 81)
m.addConstr(2*paul + 8*dale <= 68)
m.addConstr(8*hank + 2*paul <= 97)
m.addConstr(2*bobby + 8*dale <= 98)
m.addConstr(8*hank**2 + 2*bobby**2 <= 38)
m.addConstr(8*hank**2 + 2*bobby**2 + 8*dale**2 <= 59)
m.addConstr(8*hank + 2*bobby + 2*paul + 8*dale <= 59)
m.addConstr(8*hank + 3*dale <= 58)
m.addConstr(4*bobby**2 + 4*paul**2 <= 46)
m.addConstr(8*hank + 4*paul + 3*dale <= 75)
m.addConstr(8*hank + 4*bobby + 4*paul + 3*dale <= 75)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

