
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, type=gp.GRB.INTEGER) # hours worked by Hank
x1 = m.addVar(name="x1", lb=0, type=gp.GRB.INTEGER) # hours worked by Bobby
x2 = m.addVar(name="x2", lb=0) # hours worked by Paul
x3 = m.addVar(name="x3", lb=0) # hours worked by Dale

# Define the objective function
m.setObjective(1.43*x0**2 + 2.51*x0*x1 + 7.13*x0*x3 + 6.72*x2**2 + 7.26*x2*x3 + 5.39*x3**2 + 1.47*x2 + 1.27*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 <= 88)
m.addConstr(8*x0 <= 116)
m.addConstr(8*x0 <= 79)
m.addConstr(7*x1 <= 88)
m.addConstr(2*x1 <= 116)
m.addConstr(4*x1 <= 79)
m.addConstr(5*x2 <= 88)
m.addConstr(2*x2 <= 116)
m.addConstr(4*x2 <= 79)
m.addConstr(1*x3 <= 88)
m.addConstr(8*x3 <= 116)
m.addConstr(3*x3 <= 79)
m.addConstr(3*x0 + 1*x3 >= 19)
m.addConstr(3*x0**2 + 7*x1**2 >= 17)
m.addConstr(3*x0 + 7*x1 + 1*x3 >= 15)
m.addConstr(8*x0 + 2*x2 + 8*x3 >= 16)
m.addConstr(2*x1 + 2*x2 + 8*x3 >= 16)
m.addConstr(8*x0 + 2*x1 + 8*x3 >= 16)
m.addConstr(8*x0 + 2*x2 + 8*x3 >= 26)
m.addConstr(2*x1 + 2*x2 + 8*x3 >= 26)
m.addConstr(8*x0 + 2*x1 + 8*x3 >= 26)
m.addConstr(8*x0 + 2*x2 + 8*x3 >= 22)
m.addConstr(2*x1**2 + 2*x2**2 + 8*x3**2 >= 22)
m.addConstr(8*x0 + 2*x1 + 8*x3 >= 22)
m.addConstr(4*x2 + 3*x3 >= 18)
m.addConstr(2*x1**2 + 1*x3**2 >= 12)
m.addConstr(8*x0 + 4*x1 + 4*x2 + 3*x3 >= 11)
m.addConstr(3*x0 + 5*x2 <= 88)
m.addConstr(3*x0**2 + 7*x1**2 <= 58)
m.addConstr(7*x1**2 + 1*x3**2 <= 72)
m.addConstr(3*x0 + 1*x3 <= 74)
m.addConstr(3*x0 + 7*x1 + 5*x2 + 1*x3 <= 74)
m.addConstr(8*x0 + 8*x3 <= 81)
m.addConstr(2*x2 + 8*x3 <= 68)
m.addConstr(8*x0 + 2*x2 <= 97)
m.addConstr(2*x1 + 8*x3 <= 98)
m.addConstr(8*x0**2 + 2*x1**2 <= 38)
m.addConstr(8*x0**2 + 2*x1**2 + 8*x3**2 <= 59)
m.addConstr(8*x0 + 2*x1 + 2*x2 + 8*x3 <= 59)
m.addConstr(8*x0 + 3*x3 <= 58)
m.addConstr(2*x1**2 + 4*x2**2 <= 46)
m.addConstr(8*x0 + 4*x2 + 3*x3 <= 75)
m.addConstr(8*x0 + 4*x1 + 4*x2 + 3*x3 <= 75)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
