
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sashimi")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")


# Set objective function
m.setObjective(8*x0 + 3*x1 + 9*x2 + 9*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 14*x3 >= 14)
m.addConstr(6*x0 + 5*x1 >= 5)
m.addConstr(6*x0 + 13*x2 >= 10)
m.addConstr(5*x1 + 13*x2 >= 14)
m.addConstr(6*x0 + 14*x3 >= 14)
m.addConstr(6*x0 + 5*x1 + 14*x3 >= 9)
m.addConstr(6*x0 + 5*x1 + 13*x2 >= 9)
m.addConstr(6*x0 + 5*x1 + 14*x3 >= 12)
m.addConstr(6*x0 + 5*x1 + 13*x2 >= 12)
m.addConstr(6*x0 + 5*x1 + 13*x2 + 14*x3 >= 12)
m.addConstr(x2 + 4*x3 >= 15)
m.addConstr(9*x0 + x2 >= 19)
m.addConstr(9*x0 + 4*x3 >= 21)
m.addConstr(9*x0 + 12*x1 + x2 + 4*x3 >= 21)
m.addConstr(-9*x2 + 3*x3 >= 0)
m.addConstr(2*x1 - 3*x2 >= 0)
m.addConstr(13*x2 + 14*x3 <= 57)
m.addConstr(5*x1 + 13*x2 <= 52)
m.addConstr(6*x0 + 13*x2 <= 41)


# Add upper bound constraints based on resource limits
m.addConstr(6 * x0 <= 61)
m.addConstr(9 * x0 <= 144)
m.addConstr(5 * x1 <= 61)
m.addConstr(12 * x1 <= 144)
m.addConstr(13 * x2 <= 61)
m.addConstr(1 * x2 <= 144)
m.addConstr(14 * x3 <= 61)
m.addConstr(4 * x3 <= 144)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

