
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='black_beans', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='protein_bars')
    x2 = model.addVar(name='sashimi')
    x3 = model.addVar(name='rotisserie_chickens')

    # Objective function
    model.setObjective(8*x0 + 3*x1 + 9*x2 + 9*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x1 + 14*x3 >= 14)
    model.addConstr(6*x0 + 5*x1 >= 5)
    model.addConstr(6*x0 + 13*x2 >= 10)
    model.addConstr(5*x1 + 13*x2 >= 14)
    model.addConstr(6*x0 + 14*x3 >= 14)
    model.addConstr(6*x0 + 5*x1 + 14*x3 >= 9)
    model.addConstr(6*x0 + 5*x1 + 13*x2 >= 9)
    model.addConstr(6*x0 + 5*x1 + 14*x3 >= 12)
    model.addConstr(6*x0 + 5*x1 + 13*x2 >= 12)
    model.addConstr(6*x0 + 5*x1 + 13*x2 + 14*x3 >= 12)
    model.addConstr(x2 + 4*x3 >= 15)
    model.addConstr(9*x0 + x2 >= 19)
    model.addConstr(9*x0 + 4*x3 >= 21)
    model.addConstr(9*x0 + 12*x1 + x2 + 4*x3 >= 21)
    model.addConstr(-9*x2 + 3*x3 >= 0)
    model.addConstr(2*x1 - 3*x2 >= 0)
    model.addConstr(13*x2 + 14*x3 <= 57)
    model.addConstr(5*x1 + 13*x2 <= 52)
    model.addConstr(6*x0 + 13*x2 <= 41)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Black beans: ', x0.varValue)
        print('Protein bars: ', x1.varValue)
        print('Sashimi: ', x2.varValue)
        print('Rotisserie chickens: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
