
from gurobipy import *

# Create a new model
m = Model("Nutrient_Optimization")

# Define variables
x1 = m.addVar(name="vitamin_B6", lb=0)
x2 = m.addVar(name="zinc", lb=0)
x3 = m.addVar(name="vitamin_E", lb=0)
x4 = m.addVar(name="fat", lb=0)
x5 = m.addVar(name="calcium", lb=0)
x6 = m.addVar(name="vitamin_A", lb=0)
x7 = m.addVar(name="vitamin_K", lb=0)
x8 = m.addVar(name="vitamin_D", lb=0)

# Set objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 239, name="muscle_growth_B6_Zn")
m.addConstr(x2 + x6 <= 293, name="muscle_growth_Zn_A")

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

