
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B6
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY)  # milligrams of zinc
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY)  # milligrams of vitamin E
x3 = m.addVar(name="x3", lb=-gp.GRB.INFINITY)  # grams of fat
x4 = m.addVar(name="x4", lb=-gp.GRB.INFINITY)  # milligrams of calcium
x5 = m.addVar(name="x5", lb=-gp.GRB.INFINITY)  # milligrams of vitamin A
x6 = m.addVar(name="x6", lb=-gp.GRB.INFINITY)  # milligrams of vitamin K
x7 = m.addVar(name="x7", lb=-gp.GRB.INFINITY)  # milligrams of vitamin D

# Objective function
m.setObjective(2.45*x0 + 8.72*x1 + 6.56*x2 + 5.55*x3 + 3.84*x4 + 1.97*x5 + 8.33*x6 + 9.44*x7, gp.GRB.MINIMIZE)

# Digestive support index constraints
m.addConstr(15*x0 + 17*x1 + 7*x2 + 15*x3 + 3*x4 + 6*x5 + 6*x6 + 20*x7 >= 105)
m.addConstr(15*x0 + 17*x1 + 7*x2 + 15*x3 + 3*x4 + 6*x5 + 6*x6 + 20*x7 >= 123)
m.addConstr(19*x0 + 22*x1 + 8*x2 + 20*x3 + 13*x4 + 16*x5 + 13*x6 + 4*x7 >= 62)
m.addConstr(19*x0 + 22*x1 + 8*x2 + 20*x3 + 13*x4 + 16*x5 + 13*x6 + 4*x7 >= 100)
m.addConstr(10*x0 + 9*x1 + 7*x2 + 20*x3 + 6*x4 + 12*x5 + 10*x6 + 2*x7 >= 26)

# Other constraints
m.addConstr(-4*x2 + 4*x3 >= 0)
m.addConstr(-6*x2 + 7*x5 >= 0)
m.addConstr(15*x0 + 17*x1 + 7*x2 + 15*x3 + 3*x4 + 6*x5 + 6*x6 + 20*x7 <= 1222)
m.addConstr(19*x0 + 22*x1 + 8*x2 + 20*x3 + 13*x4 + 16*x5 + 13*x6 + 4*x7 <= 816)
m.addConstr(10*x0 + 9*x1 + 7*x2 + 20*x3 + 6*x4 + 12*x5 + 10*x6 + 2*x7 <= 332)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Objective value:", m.objVal)
    print("x0:", x0.varValue)
    print("x1:", x1.varValue)
    print("x2:", x2.varValue)
    print("x3:", x3.varValue)
    print("x4:", x4.varValue)
    print("x5:", x5.varValue)
    print("x6:", x6.varValue)
    print("x7:", x7.varValue)
else:
    print("No optimal solution found.")
