
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")


# Set objective function
m.setObjective(7*vitamin_b3 + 1*vitamin_k + 2*vitamin_b1 + 3*calcium + 5*vitamin_a + 9*iron, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*vitamin_b3 + 14*vitamin_k + 17*vitamin_b1 + 14*calcium + 2*vitamin_a + 1*iron <= 255, "r0")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 10*vitamin_b1 + 3*calcium + 3*vitamin_a + 9*iron <= 463, "r1")
m.addConstr(17*vitamin_b1 + 1*iron >= 31, "c1")
m.addConstr(14*vitamin_k + 1*iron >= 29, "c2")
m.addConstr(14*calcium + 1*iron >= 20, "c3")
m.addConstr(14*vitamin_k + 2*vitamin_a >= 36, "c4")
m.addConstr(5*vitamin_b3 + 14*vitamin_k + 17*vitamin_b1 + 14*calcium + 2*vitamin_a + 1*iron >= 36, "c5")
m.addConstr(3*vitamin_a + 9*iron >= 75, "c6")
m.addConstr(12*vitamin_b3 + 2*vitamin_k >= 33, "c7")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 10*vitamin_b1 >= 69, "c8")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 10*vitamin_b1 + 3*calcium + 3*vitamin_a + 9*iron >= 69, "c9")
m.addConstr(10*vitamin_b3 - 1*iron >= 0, "c10")
m.addConstr(17*vitamin_b1 + 1*iron <= 206, "c11")
m.addConstr(17*vitamin_b1 + 14*calcium <= 181, "c12")
m.addConstr(14*calcium + 1*iron <= 46, "c13")
m.addConstr(12*vitamin_b3 + 3*calcium <= 317, "c14")
m.addConstr(10*vitamin_b1 + 3*calcium <= 96, "c15")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 10*vitamin_b1 <= 248, "c16")
m.addConstr(2*vitamin_k + 10*vitamin_b1 + 3*vitamin_a <= 420, "c17")
m.addConstr(2*vitamin_k + 3*calcium + 3*vitamin_a <= 147, "c18")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 3*vitamin_a <= 234, "c19")
m.addConstr(12*vitamin_b3 + 3*calcium + 9*iron <= 168, "c20")
m.addConstr(10*vitamin_b1 + 3*vitamin_a + 9*iron <= 366, "c21")
m.addConstr(3*calcium + 3*vitamin_a + 9*iron <= 196, "c22")
m.addConstr(12*vitamin_b3 + 10*vitamin_b1 + 3*vitamin_a <= 384, "c23")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 9*iron <= 259, "c24")
m.addConstr(12*vitamin_b3 + 10*vitamin_b1 + 9*iron <= 130, "c25")
m.addConstr(12*vitamin_b3 + 2*vitamin_k + 3*calcium <= 210, "c26")
m.addConstr(12*vitamin_b3 + 3*calcium + 3*vitamin_a <= 254, "c27")
m.addConstr(2*vitamin_k + 10*vitamin_b1 + 3*calcium <= 382, "c28")
m.addConstr(12*vitamin_b3 + 10*vitamin_b1 + 3*calcium <= 106, "c29")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

