
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="x0")  # milligrams of vitamin B3
    x1 = model.addVar(lb=0, name="x1")  # milligrams of vitamin K
    x2 = model.addVar(lb=0, name="x2")  # milligrams of vitamin B1
    x3 = model.addVar(lb=0, name="x3")  # milligrams of calcium
    x4 = model.addVar(lb=0, name="x4")  # milligrams of vitamin A
    x5 = model.addVar(lb=0, name="x5")  # milligrams of iron

    # Objective function
    model.setObjective(7 * x0 + x1 + 2 * x2 + 3 * x3 + 5 * x4 + 9 * x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x0 <= 255)
    model.addConstr(12 * x0 <= 463)
    model.addConstr(14 * x1 <= 255)
    model.addConstr(2 * x1 <= 463)
    model.addConstr(17 * x2 <= 255)
    model.addConstr(10 * x2 <= 463)
    model.addConstr(14 * x3 <= 255)
    model.addConstr(3 * x3 <= 463)
    model.addConstr(2 * x4 <= 255)
    model.addConstr(3 * x4 <= 463)
    model.addConstr(x5 <= 255)
    model.addConstr(9 * x5 <= 463)
    model.addConstr(17 * x2 + x5 >= 31)
    model.addConstr(14 * x1 + x5 >= 29)
    model.addConstr(14 * x3 + x5 >= 20)
    model.addConstr(14 * x1 + 2 * x4 >= 36)
    model.addConstr(5 * x0 + 14 * x1 + 17 * x2 + 14 * x3 + 2 * x4 + x5 >= 36)
    model.addConstr(3 * x4 + 9 * x5 >= 75)
    model.addConstr(12 * x0 + 2 * x1 >= 33)
    model.addConstr(12 * x0 + 2 * x1 + 10 * x2 >= 69)
    model.addConstr(12 * x0 + 2 * x1 + 10 * x2 + 3 * x3 + 3 * x4 + 9 * x5 >= 69)
    model.addConstr(10 * x0 - x5 >= 0)
    model.addConstr(17 * x2 + x5 <= 206)
    model.addConstr(17 * x2 + 14 * x3 <= 181)
    model.addConstr(14 * x3 + x5 <= 46)
    model.addConstr(12 * x0 + 3 * x3 <= 317)
    model.addConstr(10 * x2 + 3 * x3 <= 96)
    model.addConstr(12 * x0 + 2 * x1 + 10 * x2 <= 248)
    model.addConstr(2 * x1 + 10 * x2 + 3 * x4 <= 420)
    model.addConstr(2 * x1 + 3 * x3 + 3 * x4 <= 147)
    model.addConstr(12 * x0 + 2 * x1 + 3 * x4 <= 234)
    model.addConstr(12 * x0 + 3 * x3 + 9 * x5 <= 168)
    model.addConstr(10 * x2 + 3 * x4 + 9 * x5 <= 366)
    model.addConstr(3 * x3 + 3 * x4 + 9 * x5 <= 196)
    model.addConstr(12 * x0 + 10 * x2 + 3 * x4 <= 384)
    model.addConstr(12 * x0 + 2 * x1 + 9 * x5 <= 259)
    model.addConstr(12 * x0 + 10 * x2 + 9 * x5 <= 130)
    model.addConstr(12 * x0 + 2 * x1 + 3 * x3 <= 210)
    model.addConstr(12 * x0 + 3 * x3 + 3 * x4 <= 254)
    model.addConstr(2 * x1 + 10 * x2 + 3 * x3 <= 382)
    model.addConstr(12 * x0 + 10 * x2 + 3 * x3 <= 106)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
