
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
oranges = m.addVar(name='oranges', vtype=gp.GRB.INTEGER)
potatoes = m.addVar(name='potatoes', vtype=gp.GRB.INTEGER)
eggs = m.addVar(name='eggs', vtype=gp.GRB.INTEGER)
chicken_breasts = m.addVar(name='chicken_breasts')

# Define the objective function
m.setObjective(9.81*oranges*potatoes + 4.34*potatoes*eggs + 2.15*potatoes*chicken_breasts + 4.14*chicken_breasts**2 + 1.59*eggs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*oranges + 19*potatoes >= 69)
m.addConstr(18*eggs + 10*chicken_breasts >= 55)
m.addConstr(30*oranges + 10*chicken_breasts >= 31)
m.addConstr(30*oranges + 18*eggs >= 29)
m.addConstr(30*oranges + 19*potatoes + 10*chicken_breasts >= 40)
m.addConstr(4*oranges + 12*chicken_breasts >= 56)
m.addConstr(4*oranges + 26*potatoes + 2*eggs >= 130)
m.addConstr(4*oranges + 2*eggs + 12*chicken_breasts >= 130)
m.addConstr(4*oranges + 26*potatoes + 12*chicken_breasts >= 130)
m.addConstr(4*oranges + 26*potatoes + 2*eggs >= 138)
m.addConstr(4*oranges + 2*eggs + 12*chicken_breasts >= 138)
m.addConstr(16*oranges**2 + 676*potatoes**2 + 144*chicken_breasts**2 >= 138)
m.addConstr(4*oranges + 26*potatoes + 2*eggs >= 112)
m.addConstr(4*oranges + 2*eggs + 12*chicken_breasts >= 112)
m.addConstr(4*oranges + 26*potatoes + 12*chicken_breasts >= 112)
m.addConstr(18*potatoes + 19*eggs + 12*chicken_breasts >= 50)
m.addConstr(8*oranges + 18*potatoes + 12*chicken_breasts >= 50)
m.addConstr(324*potatoes**2 + 361*eggs**2 + 144*chicken_breasts**2 >= 54)
m.addConstr(64*oranges**2 + 324*potatoes**2 + 144*chicken_breasts**2 >= 54)
m.addConstr(30*oranges + 10*chicken_breasts <= 135)
m.addConstr(19*potatoes + 10*chicken_breasts <= 261)
m.addConstr(19*potatoes + 18*eggs <= 218)
m.addConstr(30*oranges + 18*eggs + 10*chicken_breasts <= 244)
m.addConstr(30*oranges + 19*potatoes + 18*eggs + 10*chicken_breasts <= 244)
m.addConstr(2*eggs + 12*chicken_breasts <= 558)
m.addConstr(16*oranges**2 + 4*eggs**2 <= 430)
m.addConstr(26*potatoes + 12*chicken_breasts <= 533)
m.addConstr(4*oranges + 12*chicken_breasts <= 372)
m.addConstr(4*oranges + 2*eggs + 12*chicken_breasts <= 334)
m.addConstr(4*oranges + 26*potatoes + 2*eggs + 12*chicken_breasts <= 334)
m.addConstr(31*eggs + 24*chicken_breasts <= 290)
m.addConstr(27*oranges + 31*eggs <= 310)
m.addConstr(14*potatoes + 31*eggs <= 256)
m.addConstr(27*oranges + 14*potatoes <= 107)
m.addConstr(27*oranges + 24*chicken_breasts <= 299)
m.addConstr(729*oranges**2 + 196*potatoes**2 + 961*eggs**2 <= 112)
m.addConstr(27*oranges + 31*eggs + 24*chicken_breasts <= 426)
m.addConstr(27*oranges + 14*potatoes + 31*eggs + 24*chicken_breasts <= 426)
m.addConstr(64*oranges**2 + 324*potatoes**2 <= 252)
m.addConstr(361*eggs**2 + 144*chicken_breasts**2 <= 292)
m.addConstr(18*potatoes + 12*chicken_breasts <= 187)
m.addConstr(8*oranges + 19*eggs <= 95)
m.addConstr(8*oranges + 18*potatoes + 19*eggs + 12*chicken_breasts <= 95)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Oranges: ', oranges.varValue)
    print('Potatoes: ', potatoes.varValue)
    print('Eggs: ', eggs.varValue)
    print('Chicken Breasts: ', chicken_breasts.varValue)
else:
    print('No optimal solution found')
