
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    aloe_vera = m.addVar(vtype=gp.GRB.INTEGER, name="aloe_vera")
    cherry_trees = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_trees")

    # Set objective function
    m.setObjective(6 * aloe_vera + 7 * cherry_trees, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1 * aloe_vera + 15 * cherry_trees >= 39, "cost_lower_bound")
    m.addConstr(7 * aloe_vera + 16 * cherry_trees >= 14, "water_lower_bound")
    m.addConstr(9 * aloe_vera + 12 * cherry_trees >= 38, "yield_lower_bound")
    m.addConstr(14 * aloe_vera + 18 * cherry_trees >= 26, "resilience_lower_bound")
    m.addConstr(-4 * aloe_vera + 7 * cherry_trees >= 0, "custom_constraint_1")
    m.addConstr(1 * aloe_vera + 15 * cherry_trees <= 72, "cost_upper_bound")
    m.addConstr(7 * aloe_vera + 16 * cherry_trees <= 55, "water_upper_bound")
    m.addConstr(9 * aloe_vera + 12 * cherry_trees <= 99, "yield_upper_bound")
    m.addConstr(14 * aloe_vera + 18 * cherry_trees <= 57, "resilience_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('aloe_vera:', aloe_vera.x)
        print('cherry_trees:', cherry_trees.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
