
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="aloe_vera")
x2 = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")

# Define the objective function
m.setObjective(6*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 0, "non-negativity_aloe")
m.addConstr(x2 >= 0, "non-negativity_cherry")
m.addConstr(x1 + 15*x2 >= 39, "min_cost")
m.addConstr(7*x1 + 16*x2 >= 14, "min_water")
m.addConstr(9*x1 + 12*x2 >= 38, "min_yield")
m.addConstr(14*x1 + 18*x2 >= 26, "min_resilience")
m.addConstr(-4*x1 + 7*x2 >= 0, "custom_constraint")
m.addConstr(x1 + 15*x2 <= 72, "max_cost")
m.addConstr(7*x1 + 16*x2 <= 55, "max_water")
m.addConstr(9*x1 + 12*x2 <= 99, "max_yield")
m.addConstr(14*x1 + 18*x2 <= 57, "max_resilience")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Aloe Vera: {x1.x}")
    print(f"Cherry Trees: {x2.x}")
    print(f"Objective Value: {m.objVal}")
else:
    print("No optimal solution found")
