
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="aloe_vera", vtype=gurobi.GRB.INTEGER, lb=0)
x1 = model.addVar(name="cherry_trees", vtype=gurobi.GRB.INTEGER, lb=0)

# Define the objective function
model.setObjective(6 * x0 + 7 * x1, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(x0 + 15 * x1 >= 39, name="min_spend")
model.addConstr(7 * x0 + 16 * x1 >= 14, name="min_water_need")
model.addConstr(9 * x0 + 12 * x1 >= 38, name="min_yield")
model.addConstr(14 * x0 + 18 * x1 >= 26, name="min_resilience")
model.addConstr(-4 * x0 + 7 * x1 >= 0, name="linear_constraint")
model.addConstr(x0 + 15 * x1 <= 72, name="max_spend")
model.addConstr(7 * x0 + 16 * x1 <= 55, name="max_water_need")
model.addConstr(9 * x0 + 12 * x1 <= 99, name="max_yield")
model.addConstr(14 * x0 + 18 * x1 <= 57, name="max_resilience")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Aloe Vera: {x0.varValue}, Cherry Trees: {x1.varValue}")
else:
    print("No optimal solution found.")
