
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
bandwidth = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


# Set objective function
m.setObjective(9.49 * security_onions + 5.58 * bandwidth + 2.35 * network_admins + 3.46 * honeypots, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20.63 * security_onions + 19.43 * honeypots >= 70)
m.addConstr(20.63 * security_onions + 4.8 * bandwidth >= 58)
m.addConstr(2.94 * network_admins + 19.43 * honeypots >= 66)
m.addConstr(20.63 * security_onions + 2.94 * network_admins >= 54)
m.addConstr(4.8 * bandwidth + 19.43 * honeypots >= 55)
m.addConstr(4.8 * bandwidth + 2.94 * network_admins >= 33)
m.addConstr(20.63 * security_onions + 2.94 * network_admins + 19.43 * honeypots >= 40)
m.addConstr(20.63 * security_onions + 4.8 * bandwidth + 2.94 * network_admins + 19.43 * honeypots >= 40)
m.addConstr(2.64 * bandwidth + 22.65 * network_admins >= 63)
m.addConstr(13.19 * security_onions + 22.65 * network_admins >= 43)
m.addConstr(2.64 * bandwidth + 15.3 * honeypots >= 70)
m.addConstr(13.19 * security_onions + 15.3 * honeypots >= 41)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth >= 47)
m.addConstr(2.64 * bandwidth + 22.65 * network_admins + 15.3 * honeypots >= 72)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 22.65 * network_admins >= 72)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 15.3 * honeypots >= 72)
m.addConstr(2.64 * bandwidth + 22.65 * network_admins + 15.3 * honeypots >= 44)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 22.65 * network_admins >= 44)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 15.3 * honeypots >= 44)
m.addConstr(2.64 * bandwidth + 22.65 * network_admins + 15.3 * honeypots >= 36)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 22.65 * network_admins >= 36)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 15.3 * honeypots >= 36)
m.addConstr(13.19 * security_onions + 2.64 * bandwidth + 22.65 * network_admins + 15.3 * honeypots >= 36)
m.addConstr(-9 * network_admins + 2 * honeypots >= 0)
m.addConstr(-10 * security_onions + 7 * network_admins >= 0)
m.addConstr(4.8 * bandwidth + 2.94 * network_admins <= 174)
m.addConstr(20.63 * security_onions + 4.8 * bandwidth + 19.43 * honeypots <= 148)
m.addConstr(20.63 * security_onions + 2.94 * network_admins + 19.43 * honeypots <= 240)
m.addConstr(20.63 * security_onions + 4.8 * bandwidth + 2.94 * network_admins <= 260)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('security_onions:', security_onions.x)
    print('bandwidth:', bandwidth.x)
    print('network_admins:', network_admins.x)
    print('honeypots:', honeypots.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

