
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milkshakes", lb=0)
x2 = m.addVar(name="eggs", lb=0)
x3 = m.addVar(name="sashimi", lb=0)
x4 = m.addVar(name="cornichons", lb=0)
x5 = m.addVar(name="blueberry_pies", lb=0)
x6 = m.addVar(name="protein_bars", lb=0)
x7 = m.addVar(name="strawberries", lb=0)

# Objective function
m.setObjective(5*x1**2 + 8*x1*x3 + 4*x1*x4 + 8*x1*x6 + 4*x2*x6 + 4*x2*x7 + 7*x3*x4 + 9*x3*x7 + 5*x4**2 + 4*x4*x5 + 2*x4*x6 + 9*x5*x6 + 5*x5*x7 + 7*x6**2 + 3*x6*x7 + 9*x7**2 + x1 + x3 + 6*x4 + 5*x5 + 4*x6 + 6*x7, gp.GRB.MINIMIZE)

# Constraints
# Sourness index constraints
m.addConstr(1.6*x1 + 1.13*x2 + 1.77*x3 + 0.25*x4 + 1.87*x5 + 1.81*x6 + 1.62*x7 >= 23, name="sourness_index")
m.addConstr(1.6*x1 + 1.81*x6 >= 24, name="sourness_milkshakes_protein_bars")
m.addConstr(1.13*x2 + 1.62*x7 >= 23, name="sourness_eggs_strawberries")

# Fat constraints
m.addConstr(0.13*x1 + 1.49*x3 + 0.74*x5 >= 40, name="fat_sashimi_blueberry_pies")
m.addConstr(0.04*x2 + 1.49*x3 >= 28, name="fat_eggs_sashimi")
m.addConstr(0.13*x1 + 0.74*x5 >= 29, name="fat_milkshakes_blueberry_pies")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milkshakes: ", x1.varValue)
    print("Eggs: ", x2.varValue)
    print("Sashimi: ", x3.varValue)
    print("Cornichons: ", x4.varValue)
    print("Blueberry pies: ", x5.varValue)
    print("Protein bars: ", x6.varValue)
    print("Strawberries: ", x7.varValue)
else:
    print("The model is infeasible or unbounded.")
