
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
    george_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")

    # Set objective function
    model.setObjective(4.18 * dale_hours + 2.77 * bill_hours + 9.56 * george_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * dale_hours + 17 * bill_hours >= 54, "c1")
    model.addConstr(9 * dale_hours + 17 * bill_hours + 4 * george_hours >= 54, "c2")
    model.addConstr(6 * dale_hours + 16 * bill_hours >= 58, "c3")
    model.addConstr(6 * dale_hours + 3 * george_hours >= 79, "c4")
    model.addConstr(6 * dale_hours + 16 * bill_hours + 3 * george_hours >= 79, "c5")
    model.addConstr(6 * dale_hours + 4 * george_hours >= 107, "c6")
    model.addConstr(8 * bill_hours + 4 * george_hours >= 137, "c7")
    model.addConstr(6 * dale_hours + 8 * bill_hours + 4 * george_hours >= 137, "c8")
    model.addConstr(-2 * bill_hours + 6 * george_hours >= 0, "c9")
    model.addConstr(9 * dale_hours + 4 * george_hours <= 127, "c10")
    model.addConstr(17 * bill_hours + 4 * george_hours <= 202, "c11")
    model.addConstr(9 * dale_hours + 17 * bill_hours <= 286, "c12")
    model.addConstr(6 * dale_hours + 16 * bill_hours <= 293, "c13")
    model.addConstr(16 * bill_hours + 3 * george_hours <= 393, "c14")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
        print('George Hours: %g' % george_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
