
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0)  # hours worked by George

    # Define the objective function
    model.setObjective(4.18 * x0 + 2.77 * x1 + 9.56 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 + 17 * x1 >= 54)
    model.addConstr(9 * x0 + 17 * x1 + 4 * x2 >= 54)
    model.addConstr(6 * x0 + 16 * x1 >= 58)
    model.addConstr(6 * x0 + 3 * x2 >= 79)
    model.addConstr(6 * x0 + 16 * x1 + 3 * x2 >= 79)
    model.addConstr(6 * x0 + 4 * x2 >= 107)
    model.addConstr(8 * x1 + 4 * x2 >= 137)
    model.addConstr(6 * x0 + 8 * x1 + 4 * x2 >= 137)
    model.addConstr(-2 * x1 + 6 * x2 >= 0)
    model.addConstr(9 * x0 + 4 * x2 <= 127)
    model.addConstr(17 * x1 + 4 * x2 <= 202)
    model.addConstr(9 * x0 + 17 * x1 <= 286)
    model.addConstr(6 * x0 + 16 * x1 <= 293)
    model.addConstr(16 * x1 + 3 * x2 <= 393)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Dale: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by George: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
