
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bill_hours = model.addVar(lb=0, name="bill_hours")
    laura_hours = model.addVar(lb=0, name="laura_hours")
    mary_hours = model.addVar(lb=0, name="mary_hours")

    # Set objective function
    model.setObjective(3 * bill_hours + 4 * laura_hours + 9 * mary_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13 * laura_hours + 1 * mary_hours >= 94, "c1")
    model.addConstr(2 * bill_hours + 13 * laura_hours + 1 * mary_hours >= 78, "c2")
    model.addConstr(15 * bill_hours + 11 * mary_hours >= 83, "c3")
    model.addConstr(16 * laura_hours + 11 * mary_hours >= 96, "c4")
    model.addConstr(15 * bill_hours + 16 * laura_hours + 11 * mary_hours >= 56, "c5")
    model.addConstr(2 * bill_hours + 1 * mary_hours <= 241, "c6")
    model.addConstr(13 * laura_hours + 1 * mary_hours <= 264, "c7")
    model.addConstr(2 * bill_hours + 13 * laura_hours + 1 * mary_hours <= 264, "c8")
    model.addConstr(16 * laura_hours + 11 * mary_hours <= 218, "c9")
    model.addConstr(15 * bill_hours + 16 * laura_hours <= 126, "c10")
    model.addConstr(15 * bill_hours + 11 * mary_hours <= 143, "c11")
    model.addConstr(15 * bill_hours + 16 * laura_hours + 11 * mary_hours <= 109, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bill Hours: %g' % bill_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
        print('Mary Hours: %g' % mary_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
