
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Bill", lb=0)  # No upper bound given, assuming continuous
    x1 = model.addVar(name="hours_worked_by_Laura", lb=0)  # No upper bound given, assuming continuous
    x2 = model.addVar(name="hours_worked_by_Mary", lb=0)  # No upper bound given, assuming continuous

    # Define the objective function
    model.setObjective(3*x0 + 4*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*x1 + x2 >= 94)
    model.addConstr(2*x0 + 13*x1 + x2 >= 78)
    model.addConstr(15*x0 + 11*x2 >= 83)
    model.addConstr(16*x1 + 11*x2 >= 96)
    model.addConstr(15*x0 + 16*x1 + 11*x2 >= 56)
    model.addConstr(2*x0 + x2 <= 241)
    model.addConstr(13*x1 + x2 <= 264)
    model.addConstr(2*x0 + 13*x1 + x2 <= 264)
    model.addConstr(16*x1 + 11*x2 <= 218)
    model.addConstr(15*x0 + 16*x1 <= 126)
    model.addConstr(15*x0 + 11*x2 <= 143)
    model.addConstr(15*x0 + 16*x1 + 11*x2 <= 109)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bill: ", x0.varValue)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
