
import gurobipy as gp

# Create a new model
m = gp.Model("health_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_instant_ramen")


# Set objective function
m.setObjective(6*x0 + x1 + 9*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x0 + 20*x1 >= 23, "health_constraint1")
m.addConstr(7*x0 + 20*x1 + 5*x2 >= 23, "health_constraint2")
m.addConstr(5*x1 - 8*x2 >= 0, "constraint3")

# Add healthiness upper bound constraint
m.addConstr(7*x0 + 20*x1 + 5*x2 <= 130, "health_upper_bound")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Rotisserie Chickens: {x0.x}")
    print(f"Kale Salads: {x1.x}")
    print(f"Bowls of Instant Ramen: {x2.x}")
    print(f"Objective Value: {m.objVal}")

