
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="rotisserie_chickens", lb=0)  # rotisserie chickens
x2 = model.addVar(name="kale_salads", lb=0)  # kale salads
x3 = model.addVar(name="bowls_of_instant_ramen", lb=0)  # bowls of instant ramen

# Define the objective function
model.setObjective(6 * x1 + x2 + 9 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * x1 + 20 * x2 >= 23, name="healthiness_rating_chickens_salads")
model.addConstr(7 * x1 + 20 * x2 + 5 * x3 >= 23, name="healthiness_rating_all")
model.addConstr(5 * x2 - 8 * x3 >= 0, name="kale_salads_ramen_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Rotisserie Chickens: ", x1.varValue)
    print("Kale Salads: ", x2.varValue)
    print("Bowls of Instant Ramen: ", x3.varValue)
else:
    print("The model is infeasible")
