
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0")  # milligrams of vitamin B2
x1 = m.addVar(name="x1")  # milligrams of vitamin C
x2 = m.addVar(vtype=GRB.INTEGER, name="x2")  # grams of carbohydrates
x3 = m.addVar(vtype=GRB.INTEGER, name="x3")  # milligrams of vitamin K
x4 = m.addVar(name="x4")  # milligrams of vitamin B9
x5 = m.addVar(name="x5")  # milligrams of magnesium
x6 = m.addVar(name="x6")  # grams of protein
x7 = m.addVar(vtype=GRB.INTEGER, name="x7")  # milligrams of vitamin B4


# Set objective
m.setObjective(4.39*x0**2 + 7.27*x0*x1 + 5.3*x0*x2 + 9.23*x0*x3 + 9.51*x0*x4 + 1.44*x0*x5 + 3.9*x0*x6 + 8.84*x0*x7 + 2.39*x1**2 + 6.43*x1*x2 + 7.65*x1*x4 + 3.95*x1*x5 + 3.0*x1*x6 + 4.62*x1*x7 + 4.7*x2**2 + 9.0*x2*x4 + 5.95*x2*x7 + 8.22*x3**2 + 5.1*x3*x4 + 4.72*x3*x5 + 8.74*x3*x6 + 7.23*x3*x7 + 7.97*x4**2 + 4.97*x4*x5 + 7.25*x4*x6 + 7.75*x4*x7 + 8.48*x5**2 + 5.28*x5*x6 + 7.67*x5*x7 + 7.95*x6**2 + 2.99*x6*x7 + 9.64*x7**2 + 8.47*x0 + 9.99*x1 + 4.04*x2 + 4.75*x3 + 4.27*x4 + 2.71*x5 + 9.73*x6, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 8*x5 >= 14)
m.addConstr(3*x0 + 4*x7 >= 17)
m.addConstr(8*x1 + 4*x2 >= 6)
m.addConstr(6*x4 + 8*x5 >= 10)
m.addConstr(3*x0 + 7*x3 + 8*x5 >= 12)
m.addConstr(3*x0 + 8*x1 + 4*x2 + 7*x3 + 6*x4 + 8*x5 + 8*x6 + 4*x7 >= 12)
m.addConstr(2*x0**2 + 6*x1**2 + 5*x2**2 >= 18)
m.addConstr(6*x1 + 4*x4 + 8*x6 >= 18)
m.addConstr(6*x1 + 8*x6 + 4*x7 >= 18)
m.addConstr(5*x2**2 + 8*x6**2 + 4*x7**2 >= 18)
m.addConstr(2*x0 + 5*x2 + 8*x3 >= 18)
m.addConstr(2*x0 + 6*x1 + 5*x2 >= 12)
m.addConstr(6*x1 + 4*x4 + 8*x6 >= 12)
m.addConstr(6*x1**2 + 8*x6**2 + 4*x7**2 >= 12)
m.addConstr(5*x2 + 8*x6 + 4*x7 >= 12)
m.addConstr(2*x0 + 5*x2 + 8*x3 >= 12)
m.addConstr(2*x0 + 6*x1 + 5*x2 >= 13)
m.addConstr(6*x1 + 4*x4 + 8*x6 >= 13)
m.addConstr(6*x1 + 8*x6 + 4*x7 >= 13)
m.addConstr(5*x2 + 8*x6 + 4*x7 >= 13)
m.addConstr(2*x0**2 + 5*x2**2 + 8*x3**2 >= 13)
m.addConstr(2*x0 + 6*x1 + 5*x2 >= 16)
m.addConstr(6*x1 + 4*x4 + 8*x6 >= 16)
m.addConstr(6*x1**2 + 8*x6**2 + 4*x7**2 >= 16)
m.addConstr(5*x2**2 + 8*x6**2 + 4*x7**2 >= 16)
m.addConstr(2*x0 + 5*x2 + 8*x3 >= 16)
m.addConstr(2*x0**2 + 6*x1**2 + 5*x2**2 >= 16)
m.addConstr(6*x1 + 4*x4 + 8*x6 >= 16)
m.addConstr(6*x1**2 + 8*x6**2 + 4*x7**2 >= 16)
m.addConstr(5*x2 + 8*x6 + 4*x7 >= 16)
m.addConstr(2*x0 + 5*x2 + 8*x3 >= 16)
m.addConstr(2*x0 + 6*x1 + 5*x2 + 8*x3 + 4*x4 + 4*x5 + 8*x6 + 4*x7 >= 16)
m.addConstr(-3*x3 + 6*x5 >= 0)
m.addConstr(3*x0**2 + 6*x4**2 <= 77)
m.addConstr(3*x0**2 + 7*x3**2 <= 80)
m.addConstr(8*x5 + 4*x7 <= 113)
m.addConstr(6*x4 + 4*x7 <= 146)
m.addConstr(8*x1**2 + 4*x7**2 <= 127)
m.addConstr(8*x1 + 8*x6 <= 64)
m.addConstr(4*x2 + 8*x6 <= 65)
m.addConstr(2*x0 + 8*x6 + 4*x7 <= 38)
m.addConstr(2*x0 + 5*x2 + 8*x3 <= 105)

# Resource constraints
m.addConstr(3*x0 <= 164)
m.addConstr(2*x0 <= 167)
m.addConstr(8*x1 <= 164)
m.addConstr(6*x1 <= 167)
m.addConstr(4*x2 <= 164)
m.addConstr(5*x2 <= 167)
m.addConstr(7*x3 <= 164)
m.addConstr(8*x3 <= 167)
m.addConstr(6*x4 <= 164)
m.addConstr(4*x4 <= 167)
m.addConstr(8*x5 <= 164)
m.addConstr(4*x5 <= 167)
m.addConstr(8*x6 <= 164)
m.addConstr(8*x6 <= 167)
m.addConstr(4*x7 <= 164)
m.addConstr(4*x7 <= 167)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

