
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
    pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
    deployed_decoys = m.addVar(vtype=GRB.INTEGER, name="deployed_decoys")

    # Set objective function
    m.setObjective(9*honeypots*pen_testers + 7*pen_testers*deployed_decoys + 4*pen_testers, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*honeypots + 12*pen_testers + 14*deployed_decoys <= 161, "c0")
    m.addConstr(10*honeypots + 2*pen_testers + 3*deployed_decoys <= 90, "c1")
    m.addConstr(5*honeypots + 12*pen_testers + 12*deployed_decoys <= 142, "c2")
    m.addConstr(6*honeypots + 5*pen_testers + 9*deployed_decoys <= 146, "c3")
    m.addConstr(12*honeypots + 6*pen_testers + 12*deployed_decoys <= 232, "c4")
    m.addConstr(12*pen_testers + 14*deployed_decoys >= 48, "c5")
    m.addConstr(7*honeypots + 12*pen_testers >= 28, "c6")
    m.addConstr(7*honeypots*honeypots + 12*pen_testers*pen_testers + 14*deployed_decoys*deployed_decoys >= 41, "c7")
    m.addConstr(7*honeypots + 12*pen_testers + 14*deployed_decoys >= 41, "c8")
    m.addConstr(10*honeypots + 2*pen_testers >= 11, "c9")
    m.addConstr(2*pen_testers + 3*deployed_decoys >= 25, "c10")
    m.addConstr(10*honeypots + 2*pen_testers + 3*deployed_decoys >= 25, "c11")
    m.addConstr(5*honeypots + 12*pen_testers >= 38, "c12")
    m.addConstr(5*honeypots*honeypots + 12*deployed_decoys*deployed_decoys >= 31, "c13")
    m.addConstr(12*pen_testers*pen_testers + 12*deployed_decoys*deployed_decoys >= 40, "c14")
    m.addConstr(5*honeypots + 12*pen_testers + 12*deployed_decoys >= 40, "c15")
    m.addConstr(6*honeypots + 5*pen_testers >= 25, "c16")
    m.addConstr(6*honeypots*honeypots + 9*deployed_decoys*deployed_decoys >= 40, "c17")
    m.addConstr(5*pen_testers*pen_testers + 9*deployed_decoys*deployed_decoys >= 35, "c18")
    m.addConstr(6*honeypots*honeypots + 5*pen_testers*pen_testers + 9*deployed_decoys*deployed_decoys >= 25, "c19")
    m.addConstr(6*honeypots + 5*pen_testers + 9*deployed_decoys >= 25, "c20")
    m.addConstr(12*honeypots + 12*deployed_decoys >= 36, "c21")
    m.addConstr(6*pen_testers*pen_testers + 12*deployed_decoys*deployed_decoys >= 59, "c22")
    m.addConstr(12*honeypots + 6*pen_testers + 12*deployed_decoys >= 59, "c23")
    m.addConstr(4*pen_testers - 4*deployed_decoys >= 0, "c24")
    m.addConstr(7*honeypots*honeypots + 12*pen_testers*pen_testers + 14*deployed_decoys*deployed_decoys <= 159, "c25")
    m.addConstr(5*honeypots + 12*deployed_decoys <= 54, "c26")
    m.addConstr(5*honeypots*honeypots + 12*pen_testers*pen_testers <= 78, "c27")
    m.addConstr(12*honeypots + 6*pen_testers + 12*deployed_decoys <= 198, "c28")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('honeypots:', honeypots.x)
        print('pen_testers:', pen_testers.x)
        print('deployed_decoys:', deployed_decoys.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
