
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="deployed_decoys", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9*x0*x1 + 7*x1*x2 + 4*x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x0 + 12*x1 + 14*x2 >= 48)
m.addConstr(7*x0 + 12*x1 >= 28)
m.addConstr(49*x0**2 + 144*x1**2 + 196*x2**2 >= 41)
m.addConstr(7*x0 + 12*x1 + 14*x2 >= 41)
m.addConstr(10*x0 + 2*x1 >= 11)
m.addConstr(2*x1 + 3*x2 >= 25)
m.addConstr(10*x0 + 2*x1 + 3*x2 >= 25)
m.addConstr(5*x0 + 12*x1 >= 38)
m.addConstr(25*x0**2 + 144*x2**2 >= 31)
m.addConstr(144*x1**2 + 144*x2**2 >= 40)
m.addConstr(5*x0 + 12*x1 + 12*x2 >= 40)
m.addConstr(6*x0 + 5*x1 >= 25)
m.addConstr(36*x0**2 + 81*x2**2 >= 40)
m.addConstr(25*x1**2 + 81*x2**2 >= 35)
m.addConstr(36*x0**2 + 25*x1**2 + 81*x2**2 >= 25)
m.addConstr(6*x0 + 5*x1 + 9*x2 >= 25)
m.addConstr(12*x0 + 12*x2 >= 36)
m.addConstr(36*x1**2 + 144*x2**2 >= 59)
m.addConstr(12*x0 + 6*x1 + 12*x2 >= 59)
m.addConstr(4*x1 - 4*x2 >= 0)
m.addConstr(49*x0**2 + 144*x1**2 + 196*x2**2 <= 159)
m.addConstr(5*x0 + 12*x2 <= 54)
m.addConstr(25*x0**2 + 144*x1**2 <= 78)
m.addConstr(12*x0 + 6*x1 + 12*x2 <= 198)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Honeypots: ", x0.varValue)
    print("Pen testers: ", x1.varValue)
    print("Deployed decoys: ", x2.varValue)
else:
    print("The model is infeasible")
