
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("planting_optimization")

# Create variables
verbenas = m.addVar(vtype=GRB.INTEGER, name="verbenas")
tulips = m.addVar(vtype=GRB.INTEGER, name="tulips")

# Set objective function
m.setObjective(9 * verbenas + 8 * tulips, GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * verbenas + 19 * tulips >= 30 * 144, "min_planting_space")  # 30 sq ft in sq inches
m.addConstr(7 * verbenas - 4 * tulips >= 0, "verbenas_tulips_ratio")
m.addConstr(10 * verbenas + 19 * tulips <= 82 * 144, "max_planting_space") # 82 sq ft in sq inches


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Verbenas: {verbenas.x}")
    print(f"  Tulips: {tulips.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

