
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="verbenas")
x2 = m.addVar(vtype=GRB.INTEGER, name="tulips")

# Objective function: Minimize 9*x1 + 8*x2
m.setObjective(9*x1 + 8*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(10*x1 + 19*x2 >= 4320)  # At least 30 sq. ft (converted to sq. in)
m.addConstr(10*x1 + 19*x2 <= 11808)  # Total space not more than 82 sq. ft (converted to sq. in)
m.addConstr(7*x1 - 4*x2 >= 0)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Verbenas: {x1.x}")
    print(f"Tulips: {x2.x}")
else:
    print("No optimal solution found")
