
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    verbenas = model.addVar(name="verbenas", vtype=gurobi.GRB.INTEGER)
    tulips = model.addVar(name="tulips", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9 * verbenas + 8 * tulips, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * verbenas + 19 * tulips >= 4320, name="space_requirement")
    model.addConstr(7 * verbenas - 4 * tulips >= 0, name="verbenas_vs_tulips")
    model.addConstr(10 * verbenas + 19 * tulips <= 11808, name="total_space")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Verbenas: {verbenas.varValue}")
        print(f"Tulips: {tulips.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
