
import gurobipy as gp

# Create a new model
model = gp.Model("Organization_Score_Optimization")

# Create variables
peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")


# Set objective function
model.setObjective(6.32 * peggy_hours + 6.84 * ringo_hours + 4.46 * laura_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * peggy_hours + 12 * ringo_hours <= 60, "c1")
model.addConstr(1 * peggy_hours + 3 * laura_hours <= 147, "c2")
model.addConstr(1 * peggy_hours + 12 * ringo_hours + 3 * laura_hours <= 147, "c3")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Ringo's hours: {ringo_hours.x}")
    print(f"Laura's hours: {laura_hours.x}")

elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

