
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x2 = m.addVar(name="hours_worked_by_Ringo", lb=0)
x3 = m.addVar(name="hours_worked_by_Laura", lb=0)

# Set the objective function
m.setObjective(6.32*x1 + 6.84*x2 + 4.46*x3, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(x1 + 12*x2 <= 60)
m.addConstr(x1 + 3*x3 <= 147)
m.addConstr(x1 + 12*x2 + 3*x3 <= 179)

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective Value:", m.objVal)
