
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="hours_worked_by_Peggy", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="hours_worked_by_Ringo", vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(lb=0, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(6.32*x1 + 6.84*x2 + 4.46*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + 12*x2 <= 60)
    model.addConstr(x1 + 3*x3 <= 147)
    model.addConstr(x1 + 12*x2 + 3*x3 <= 147)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Hours worked by Laura: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
