
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("computer_competence")

# Create variables
laura = m.addVar(vtype=GRB.INTEGER, name="laura")
dale = m.addVar(vtype=GRB.CONTINUOUS, name="dale")
bill = m.addVar(vtype=GRB.INTEGER, name="bill")
jean = m.addVar(vtype=GRB.INTEGER, name="jean")


# Set objective function
m.setObjective(8.25 * laura + 4.08 * dale + 6.03 * bill + 4.11 * jean, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * laura + 10 * bill >= 14, "c1")
m.addConstr(10 * bill + 8 * jean >= 14, "c2")
m.addConstr(4 * laura + 5 * dale + 10 * bill >= 12, "c3")
m.addConstr(4 * laura + 5 * dale + 8 * jean >= 12, "c4")
m.addConstr(4 * laura + 5 * dale + 10 * bill >= 10, "c5")
m.addConstr(4 * laura + 5 * dale + 8 * jean >= 10, "c6")
m.addConstr(4 * laura + 5 * dale + 10 * bill + 8 * jean >= 10, "c7")
m.addConstr(laura - 9 * jean >= 0, "c8")
m.addConstr(4 * laura + 10 * bill <= 18, "c9")
m.addConstr(5 * dale + 10 * bill <= 72, "c10")
m.addConstr(4 * laura + 5 * dale <= 28, "c11")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

