
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Dale")
x3 = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="hours_worked_by_Jean", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8.25*x1 + 4.08*x2 + 6.03*x3 + 4.11*x4, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(4*x1 + 10*x3 >= 14)
m.addConstr(10*x3 + 8*x4 >= 14)
m.addConstr(4*x1 + 5*x2 + 10*x3 >= 12)
m.addConstr(4*x1 + 5*x2 + 8*x4 >= 12)
m.addConstr(4*x1 + 5*x2 + 10*x3 >= 10)
m.addConstr(4*x1 + 5*x2 + 8*x4 >= 10)
m.addConstr(4*x1 + 5*x2 + 10*x3 + 8*x4 >= 10)
m.addConstr(x1 - 9*x4 >= 0)
m.addConstr(4*x1 + 10*x3 <= 18)
m.addConstr(5*x2 + 10*x3 <= 72)
m.addConstr(4*x1 + 5*x2 <= 28)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Dale: ", x2.varValue)
    print("Hours worked by Bill: ", x3.varValue)
    print("Hours worked by Jean: ", x4.varValue)
else:
    print("The model is infeasible")
