
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")


    # Set objective function
    model.setObjective(3*x0**2 + 1*x0*x1 + 1*x0, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1*x0 + 6*x1 >= 61, "c0")
    model.addConstr(17*x0 + 11*x1 >= 52, "c1")
    model.addConstr(12*x0 + 7*x1 >= 69, "c2")
    model.addConstr(1*x0 + 14*x1 >= 25, "c3")
    model.addConstr(3*x0**2 - 10*x1**2 >= 0, "c4")
    model.addConstr(1*x0 + 6*x1 <= 133, "c5")
    model.addConstr(17*x0**2 + 11*x1**2 <= 108, "c6")
    model.addConstr(12*x0 + 7*x1 <= 165, "c7")
    model.addConstr(1*x0**2 + 14*x1**2 <= 35, "c8")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"x0 = {x0.x}")
        print(f"x1 = {x1.x}")
        print(f"Objective value = {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable definitions and constraint formulations.")

