
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name='hours_worked_by_Hank', lb=0)
x2 = m.addVar(name='hours_worked_by_Jean', lb=0)

# Objective function
m.setObjective(3*x1**2 + x1*x2 + x1, GRB.MINIMIZE)

# Constraints
m.addConstr(17*x1 + 11*x2 >= 52, name='combined_computer_competence')
m.addConstr(12*x1 + 7*x2 >= 69, name='combined_likelihood_to_quit')
m.addConstr(x1 + 14*x2 >= 25, name='combined_organization_score')
m.addConstr(3*x1**2 - 10*x2**2 >= 0, name='quadratic_constraint')
m.addConstr(x1 + 6*x2 <= 133, name='upper_bound_dollar_cost')
m.addConstr((17*x1)**2 + (11*x2)**2 <= 108, name='upper_bound_squared_computer_competence')
m.addConstr(12*x1 + 7*x2 <= 165, name='upper_bound_likelihood_to_quit')
m.addConstr((x1)**2 + (14*x2)**2 <= 35, name='upper_bound_squared_organization_score')

# Optimize
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Hank: {x1.X}')
    print(f'Hours worked by Jean: {x2.X}')
else:
    print('No optimal solution found')
