
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Hank", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="hours_worked_by_Jean", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3*x1**2 + x1*x2 + x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x1 + 6*x2 >= 61)
m.addConstr(17*x1 + 11*x2 >= 52)
m.addConstr(12*x1 + 7*x2 >= 69)
m.addConstr(1*x1 + 14*x2 >= 25)
m.addConstr(1*x1 + 6*x2 <= 133)
m.addConstr(17*x1 + 11*x2 <= 157)
m.addConstr(12*x1 + 7*x2 <= 201)
m.addConstr(1*x1 + 14*x2 <= 71)
m.addConstr(3*x1**2 - 10*x2**2 >= 0)
m.addConstr(12*x1 + 7*x2 <= 165)
m.addConstr(x1**2 + 196*x2**2 <= 35)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x1.varValue}")
    print(f"Hours worked by Jean: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
