
from gurobipy import *

# Create a new model
m = Model("Food_Optimization")

# Define the variables
x1 = m.addVar(name='Blueberry_pies')
x2 = m.addVar(name='Apples')
x3 = m.addVar(name='Chicken_breasts')
x4 = m.addVar(name='Green_beans')
x5 = m.addVar(name='Chicken_thighs')
x6 = m.addVar(name='Rotisserie_chickens')
x7 = m.addVar(name='Bagged_salads')

# Objective function (example: minimize total quantity)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Add constraints (examples)
m.addConstr(20*x3 + 15*x5 + 10*x6 >= 100, name='Protein_requirement')
m.addConstr(x2 + x7 <= 159, name='Sourness_limit')
m.addConstr(5*x3 + 10*x4 + 8*x6 <= 166, name='Iron_limit')

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f'{v.varName}: {v.x}')

