
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="blueberry_pies", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x1 = model.addVar(name="apples", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name="chicken_breasts", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x3 = model.addVar(name="green_beans", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x4 = model.addVar(name="chicken_thighs", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x5 = model.addVar(name="rotisserie_chickens", lb=0, vtype=gurobi.GRB.CONTINUOUS)
x6 = model.addVar(name="bagged_salads", lb=0, vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(4.69*x0*x1 + 4.68*x0*x5 + 7.01*x1*x3 + 9.9*x2*x3 + 3.66*x2*x5 + 1.95*x1 + 3.88*x6, gurobi.GRB.MINIMIZE)

# Add constraints
# Iron constraints
model.addConstr(8*x0 + 13*x1 + 12*x2 + 5*x3 + 5*x4 + 7*x5 + 9*x6 <= 222, name="iron_constraint")
# Calcium constraints
model.addConstr(10*x0 + 5*x1 + 7*x2 + 3*x3 + 4*x4 + 11*x5 + 5*x6 <= 181, name="calcium_constraint")
# Sourness index constraints
model.addConstr(13*x0 + x1 + 5*x2 + 3*x3 + 14*x4 + 10*x5 + x6 <= 195, name="sourness_index_constraint")
# Protein constraints
model.addConstr(14*x0 + 14*x1 + 14*x2 + 6*x3 + 5*x4 + 3*x5 + 4*x6 <= 169, name="protein_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("blueberry_pies: ", x0.varValue)
    print("apples: ", x1.varValue)
    print("chicken_breasts: ", x2.varValue)
    print("green_beans: ", x3.varValue)
    print("chicken_thighs: ", x4.varValue)
    print("rotisserie_chickens: ", x5.varValue)
    print("bagged_salads: ", x6.varValue)
else:
    print("The model is infeasible or unbounded.")
