
import gurobipy as gp

# Create a new model
model = gp.Model("Nutrition_Optimization")

# Create variables
x = model.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Potassium", "Vitamin B12", "Calcium", "Fiber", "Vitamin A"])


# Set objective function
model.setObjective(6.79 * x[0] + 6.61 * x[1] + 3.63 * x[2] + 6.11 * x[3] + 2.51 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(13 * x[0] + 9 * x[1] + 21 * x[2] + 10 * x[3] + 5 * x[4] <= 164, "Kidney_Support_Index")
model.addConstr(3 * x[2] - 10 * x[3] - 7 * x[4] >= 0, "Nutrient_Balance")
model.addConstr(13 * x[0] + 5 * x[4] <= 106, "Potassium_VitaminA_KSI")
model.addConstr(21 * x[2] + 5 * x[4] <= 53, "Calcium_VitaminA_KSI")
model.addConstr(9 * x[1] + 10 * x[3] <= 80, "VitaminB12_Fiber_KSI")
model.addConstr(9 * x[1] + 5 * x[4] <= 47, "VitaminB12_VitaminA_KSI")
model.addConstr(13 * x[0] + 9 * x[1] <= 44, "Potassium_VitaminB12_KSI")
model.addConstr(13 * x[0] + 21 * x[2] <= 95, "Potassium_Calcium_KSI")
model.addConstr(9 * x[1] + 21 * x[2] <= 64, "VitaminB12_Calcium_KSI")
model.addConstr(21 * x[2] + 10 * x[3] <= 130, "Calcium_Fiber_KSI")
model.addConstr(21 * x[2] + 10 * x[3] + 5 * x[4] <= 109, "Calcium_Fiber_VitaminA_KSI")
model.addConstr(13 * x[0] + 21 * x[2] + 10 * x[3] <= 101, "Potassium_Calcium_Fiber_KSI")
model.addConstr(13 * x[0] + 9 * x[1] + 21 * x[2] <= 140, "Potassium_VitaminB12_Calcium_KSI")
model.addConstr(9 * x[1] + 10 * x[3] + 5 * x[4] <= 140, "VitaminB12_Fiber_VitaminA_KSI")
model.addConstr(13 * x[0] + 21 * x[2] + 5 * x[4] <= 118, "Potassium_Calcium_VitaminA_KSI")
model.addConstr(13 * x[0] + 9 * x[1] + 5 * x[4] <= 151, "Potassium_VitaminB12_VitaminA_KSI")
model.addConstr(13 * x[0] + 9 * x[1] + 21 * x[2] + 10 * x[3] + 5 * x[4] <= 151, "Total_KSI")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

