
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="milligrams of potassium")
x2 = model.addVar(lb=0, name="milligrams of vitamin B12")
x3 = model.addVar(lb=0, name="milligrams of calcium")
x4 = model.addVar(lb=0, name="grams of fiber")
x5 = model.addVar(lb=0, name="milligrams of vitamin A")

# Objective function
model.setObjective(6.79*x1 + 6.61*x2 + 3.63*x3 + 6.11*x4 + 2.51*x5, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x3 - 10*x4 - 7*x5 >= 0)
model.addConstr(13*x1 + 5*x5 <= 106)
model.addConstr(21*x3 + 5*x5 <= 53)
model.addConstr(9*x2 + 10*x4 <= 80)
model.addConstr(9*x2 + 5*x5 <= 47)
model.addConstr(13*x1 + 9*x2 <= 44)
model.addConstr(13*x1 + 21*x3 <= 95)
model.addConstr(9*x2 + 21*x3 <= 64)
model.addConstr(21*x3 + 10*x4 <= 130)
model.addConstr(21*x3 + 10*x4 + 5*x5 <= 109)
model.addConstr(13*x1 + 21*x3 + 10*x4 <= 101)
model.addConstr(13*x1 + 9*x2 + 21*x3 <= 140)
model.addConstr(9*x2 + 10*x4 + 5*x5 <= 140)
model.addConstr(13*x1 + 21*x3 + 5*x5 <= 118)
model.addConstr(13*x1 + 9*x2 + 5*x5 <= 151)
model.addConstr(13*x1 + 9*x2 + 21*x3 + 10*x4 + 5*x5 <= 151)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of potassium: ", x1.varValue)
    print("Milligrams of vitamin B12: ", x2.varValue)
    print("Milligrams of calcium: ", x3.varValue)
    print("Grams of fiber: ", x4.varValue)
    print("Milligrams of vitamin A: ", x5.varValue)
    print("Objective function value: ", model.objVal)
else:
    print("No optimal solution found.")
