
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = m.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")
    paul_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="paul_hours")
    laura_hours = m.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")

    # Set objective function
    m.setObjective(1 * dale_hours + 1 * paul_hours + 6 * laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1 * dale_hours + 16 * paul_hours + 15 * laura_hours >= 64, "c1")
    m.addConstr(6 * dale_hours - 4 * laura_hours >= 0, "c2")
    m.addConstr(31 * dale_hours + 1 * laura_hours <= 227, "c3")
    m.addConstr(31 * dale_hours + 24 * paul_hours + 1 * laura_hours <= 227, "c4")
    m.addConstr(1 * dale_hours + 15 * laura_hours <= 151, "c5")
    m.addConstr(1 * dale_hours + 16 * paul_hours <= 182, "c6")
    m.addConstr(1 * dale_hours + 16 * paul_hours + 15 * laura_hours <= 162, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
