
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_Dale', vtype='I')  # Integer
    x1 = model.addVar(name='hours_worked_by_Paul', vtype='C')  # Continuous
    x2 = model.addVar(name='hours_worked_by_Laura', vtype='I')  # Integer

    # Define the objective function
    model.setObjective(x0 + x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x0 + 16 * x1 + 15 * x2 >= 64)
    model.addConstr(6 * x0 - 4 * x2 >= 0)
    model.addConstr(31 * x0 + x2 <= 227)
    model.addConstr(31 * x0 + 24 * x1 + x2 <= 227)
    model.addConstr(x0 + 15 * x2 <= 151)
    model.addConstr(x0 + 16 * x1 <= 182)
    model.addConstr(x0 + 16 * x1 + 15 * x2 <= 162)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Dale: {x0.varValue}')
        print(f'Hours worked by Paul: {x1.varValue}')
        print(f'Hours worked by Laura: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
