
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")

# Set objective function
m.setObjective(8.2 * bobby + 6.37 * laura + 1.82 * george + 2.51 * peggy + 7.39 * hank, gp.GRB.MAXIMIZE)

# Add constraints

# likelihood to quit index constraints
m.addConstr(10 * laura + 18 * george >= 33)
m.addConstr(1 * peggy + 12 * hank >= 49)
m.addConstr(10 * laura + 1 * peggy + 12 * hank >= 45)
m.addConstr(22 * bobby + 10 * laura + 18 * george >= 45)
m.addConstr(10 * laura + 12 * hank <= 131)
m.addConstr(peggy + 12 * hank <= 89)
m.addConstr(22 * bobby + 18 * george <= 193)
m.addConstr(22 * bobby + 10 * laura + 18 * george + peggy + 12 * hank <= 193)


# work quality rating constraints
m.addConstr(4 * laura + 23 * george + 20 * hank >= 72) # Dominant constraint
m.addConstr(11 * bobby + 4 * laura + 20 * hank >= 72) # Dominant constraint
m.addConstr(11 * bobby + 23 * george + 20 * hank >= 72) # Dominant constraint
m.addConstr(4 * laura + 23 * george + 12 * peggy >= 72) # Dominant constraint
m.addConstr(11 * bobby + 4 * laura + 23 * george >= 72) # Dominant constraint
m.addConstr(4 * laura + 12 * peggy + 20 * hank >= 72) # Dominant constraint
m.addConstr(11 * bobby + 12 * peggy + 20 * hank >= 72) # Dominant constraint

m.addConstr(23 * george + 12 * peggy <= 310)
m.addConstr(12 * peggy + 20 * hank <= 265)
m.addConstr(23 * george + 20 * hank <= 296)
m.addConstr(11 * bobby + 4 * laura <= 111)
m.addConstr(11 * bobby + 23 * george <= 124)
m.addConstr(4 * laura + 12 * peggy <= 221)
m.addConstr(11 * bobby + 4 * laura + 23 * george + 12 * peggy + 20 * hank <= 221)


# computer competence rating constraints
m.addConstr(17 * bobby + 7 * peggy >= 90)
m.addConstr(17 * bobby + 20 * laura + 23 * hank >= 112) # Dominant constraint
m.addConstr(17 * bobby + 7 * peggy + 23 * hank >= 112) # Dominant constraint
m.addConstr(5 * george + 7 * peggy + 23 * hank >= 112) # Dominant constraint
m.addConstr(20 * laura + 7 * peggy + 23 * hank >= 112) # Dominant constraint
m.addConstr(20 * laura + 5 * george + 23 * hank >= 112) # Dominant constraint
m.addConstr(20 * laura + 5 * george + 7 * peggy >= 112) # Dominant constraint
m.addConstr(17 * bobby + 20 * laura + 7 * peggy >= 112) # Dominant constraint

m.addConstr(5 * george + 7 * peggy <= 204)
m.addConstr(7 * peggy + 23 * hank <= 490)
m.addConstr(17 * bobby + 20 * laura <= 256)
m.addConstr(17 * bobby + 20 * laura + 5 * george + 7 * peggy + 23 * hank <= 256)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

